<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>


<!-- Contact Us -->
<div class="contact-us-footer-main-section full" id="contactus">
	<div class="container">
		<div class="contact-us-heading full">
			<h1>Contact Us</h1>
		</div>
		
		<div class="full contact-form-section">
			
			<?php echo do_shortcode('[contact-form-7 id="9" title="Contact Form"]');?>
			
		</div>
		
		<div class="contact-section-contact-details full">
			<!-- Contact Single -->
			<div class="contact-single-sec phone-sec-contact left">
				<div class="full contact-icon">
					<img src="<?php echo get_template_directory_uri();?>/images/phone-icon.png" alt="" />
				</div>
				<h4>Get in Touch</h4>	
				<p><a href="tel:+923053978663">+92 305 3978663</a></p>
			</div>
			<div class="contact-single-sec email-sec-contact left">
				<div class="full contact-icon">
					<img src="<?php echo get_template_directory_uri();?>/images/email-icon.png" alt="" />
				</div>
				<h4>Email Us</h4>	
				<p><a href="mailto:support@goldenkeystone.com">support@goldenkeystone.com</a></p>
			</div>
			<div class="contact-single-sec address-sec-contact left no-margin-rignt">
				<div class="full contact-icon">
					<img src="<?php echo get_template_directory_uri();?>/images/address-icon.png" alt="" />
				</div>
				<h4>Address</h4>	
				<p><a href="#">Building #10, 2nd Floor, Commercial Area, Tech society Lahore, Punjab, Pakistan</a></p>
			</div>
			
			<div class="clear"></div>
		</div>
	</div>
</div>
<div class="footer-bottom-bar-section full">
	<div class="container">
		<div class="right footer-menu-section">
			<?php echo wp_nav_menu(array('menu' => 'Footer Menu'));?>
		</div>
		
		<div class="left footer-copyright-section">
			<p>© 2021 Golden Keystone. All right reserved.</p>
		</div>
		<div class="clear"></div>
	</div>
</div>


<script>
$(document).ready(function(){
	// Slider on home page
	$('.home-page-slider').owlCarousel({
		loop:true,
		//margin:10,
		nav:false,
		items:1,
		dots: false,
		autoplay:true,
		slideSpeed: 2000,
	});
	
	jQuery('.header-menu-btn-section').click(function(){
		jQuery('.menu-section-main-sec').toggleClass('active');
	})
	
	jQuery('.closebtn i').click(function(){
		jQuery('.menu-section-main-sec').removeClass('active');
	})
	
	jQuery('.menu-section-main-sec ul li a').click(function(){
		jQuery('.menu-section-main-sec').removeClass('active');
	})
	
	
	
});
</script>



<?php wp_footer(); ?>




</body>
</html>
